/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.prodos;

import com.webcodepro.applecommander.storage.os.prodos.ProdosCommonDirectoryHeader;
import com.webcodepro.applecommander.storage.os.prodos.ProdosDirectoryEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;

public class ProdosSubdirectoryHeader
extends ProdosCommonDirectoryHeader {
    private ProdosDirectoryEntry directoryEntry;

    public ProdosSubdirectoryHeader(ProdosFormatDisk disk, int block) {
        super(disk, block);
    }

    public String getSubdirectoryName() {
        return AppleUtil.getProdosString(this.readFileEntry(), 0);
    }

    public int getParentPointer() {
        return AppleUtil.getWordValue(this.readFileEntry(), 35);
    }

    public void setParentPointer(int block) {
        byte[] data = this.readFileEntry();
        AppleUtil.setWordValue(data, 35, block);
        this.writeFileEntry(data);
    }

    public int getParentEntry() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[37]);
    }

    public void setParentEntry(int entryNum) {
        byte[] data = this.readFileEntry();
        data[37] = (byte)entryNum;
        this.writeFileEntry(data);
    }

    public int getParentEntryLength() {
        return AppleUtil.getWordValue(this.readFileEntry(), 38);
    }

    public void setParentEntryLength(int length) {
        byte[] data = this.readFileEntry();
        data[38] = (byte)length;
        this.writeFileEntry(data);
    }

    public void setProdosDirectoryEntry(ProdosDirectoryEntry directoryEntry) {
        this.directoryEntry = directoryEntry;
    }

    public ProdosDirectoryEntry getProdosDirectoryEntry() {
        return this.directoryEntry;
    }

    public void setHousekeeping() {
        byte[] data = this.readFileEntry();
        data[0] = (byte)(0xE0 | data[0] & 0xF);
        data[16] = 117;
        data[31] = 39;
        data[32] = 13;
        AppleUtil.setWordValue(data, 33, 0);
        this.writeFileEntry(data);
    }
}

